#!/bin/sh

echo "Changing executable permissions.."
chmod 755 ./VSG25 || exit
chmod 755 ./bin/VSG25 || exit

echo "Configuring libraries.."
if [ ! -d "./lib" ]; then echo "Error: ./lib directory not found" && exit; fi
ldconfig -n ./lib

echo "Changing device permissions.."
sudo cp ./sh.rules /etc/udev/rules.d/ || exit

echo "Adding launcher icon.."
ICON_FILE=./assets/com.signalhound.vsg25.png
APP_TEMPLATE=./com.signalhound.vsg25.desktop
APP_DEST=/usr/share/applications/com.signalhound.vsg25.desktop
sudo install -m 644 $ICON_FILE /usr/share/icons
cat $APP_TEMPLATE | sed s:INSTALL_DIR:$(pwd):g | sudo tee $APP_DEST >/dev/null
sudo update-desktop-database /usr/share/applications

FILE=/etc/udev/rules.d/sh.rules
if test -f "$FILE"; then
    echo "\nInstallation successful\n\nRun VSG25 software in terminal with ./VSG25\nor in Files by double-clicking 'VSG25'\nor from the system application launcher\n"
else
    echo "\nUnable to change device permissions. Please copy sh.rules to /etc/udev/rules.d.\n"
fi
