#!/bin/sh

echo "Changing executable permissions.."
chmod 755 ./VNA
chmod 755 ./bin/VNA

echo "Configuring libraries.."
ldconfig -n ./lib

echo "Changing device permissions.."
sudo cp ./sh.rules /etc/udev/rules.d/

FILE=/etc/udev/rules.d/sh.rules
if test -f "$FILE"; then
    echo "\nInstallation successful\n\nRun VNA400 software in terminal with ./VNA\nor in Files by double-clicking 'VNA'\n"
else
    echo "\nUnable to change device permissions. Please copy sh.rules to /etc/udev/rules.d.\n"
fi
