#!/bin/sh

echo -e "Changing executable permissions.."
chmod 755 ./Spike || exit
chmod 755 ./bin/Spike || exit

echo -e "Configuring libraries.."
if [ ! -d "./lib" ]; then echo -e "Error: ./lib directory not found" && exit; fi
ldconfig -n ./lib

echo -e "Changing device permissions.."
sudo cp ./sh.rules /etc/udev/rules.d/ || exit

echo -e "Adding launcher icon.."
ICON_FILE=./assets/com.signalhound.spike.png
APP_TEMPLATE=./com.signalhound.spike.desktop
APP_DEST=/usr/share/applications/com.signalhound.spike.desktop
sudo install -m 644 $ICON_FILE /usr/share/icons
cat $APP_TEMPLATE | sed s:INSTALL_DIR:$(pwd):g | sudo tee $APP_DEST >/dev/null
sudo update-desktop-database /usr/share/applications

FILE=/etc/udev/rules.d/sh.rules
if test -f "$FILE"; then
    echo -e "\nInstallation successful\n\nRun Spike in terminal with ./Spike\nor in Files by double-clicking 'Spike'\nor from the system application launcher\n"
else
    echo -e "\nUnable to change device permissions. Please copy sh.rules to /etc/udev/rules.d.\n"
fi
