#include "pcr_api.h"

#include <iostream>
#include <cassert>


void pcr_example_external_pps()
{
    PCRStatus sts;
    int handle;
    const int streamingChannels = 4;
    const double centerFreq = 1000.0e6;
    const int decimation = 1; // [1,2,4]
    const double refLevel = -20.0;
    // The destination network address
    const uint64_t mac = 0x3CFDFE9ECF10;
    const char* hostIP = "192.168.2.2";
    const uint16_t port = 4992;

    sts = pcrConnectDevice(&handle, PCR_DEFAULT_HOST_ADDR, PCR_DEFAULT_DEVICE_ADDR, PCR_DEFAULT_PORT);
    assert(sts == PCRStatusNoError);
    printf("Connected\n");


    // Setup the VRT stream
    sts = pcrSetStreamMode(handle, PCRStreamModeVRT);
    assert(sts == PCRStatusNoError);
    for (int i = 0; i < streamingChannels; i++) {
        sts = pcrSetStreamVrtChannelID(handle, i, i);
        assert(sts == PCRStatusNoError);
        sts = pcrSetStreamVrtAddr(handle, i, hostIP, port, mac);
        assert(sts == PCRStatusNoError);
    }
    sts = pcrSetStreamVrtCntxInterval(handle, PCRBoolTrue, 63);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamVrtEndianness(handle, PCREndiannessBig);
    assert(sts == PCRStatusNoError);
 
    // Configure Stream
    // Now setup the channels + measurement
    int chEnabled[4] = { 1, 1, 1, 1 };
    sts = pcrSetChannelConfig(handle, chEnabled, PCR_SWEEP_CHANNEL_DISABLED);
    assert(sts == PCRStatusNoError);
    for (int j = 0; j < streamingChannels; j++) {
        sts = pcrSetChannelShared(handle, j, PCRBoolTrue);
        assert(sts == PCRStatusNoError);
    }
    sts = pcrSetSharedFreq(handle, centerFreq);
    assert(sts == PCRStatusNoError);
    sts = pcrSetVSGEnabled(handle, PCRBoolFalse);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamDataType(handle, PCRDataType32fc);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamRefLevel(handle, refLevel);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamAtten(handle, PCR_AUTO_ATTEN);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamSampleRate(handle, decimation);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamBandwidth(handle, PCR_STREAM_MAX_BW / (double)decimation);
    assert(sts == PCRStatusNoError);
    sts = pcrSetPPSSource(handle, PCRBoolTrue); // use external PPS
    assert(sts == PCRStatusNoError);
    sts = pcrInitiate(handle);
    assert(sts == PCRStatusNoError);

    // Set to a time that is easy to visually observe.
    sts = pcrSetTime(handle, 1700000000);
    assert(sts == PCRStatusNoError);

    printf("PCR4200 is Streaming Vita49 Data to %s port %d\n", hostIP, port);
}
