
// UsingWinHeadlessDoc.cpp : implementation of the CUsingWinHeadlessDoc class
// Created 2012 APR 19 to test the windows-based Headless API

#include "stdafx.h"
#include "UsingWinHeadless.h"

#include "UsingWinHeadlessDoc.h"
#include "MySignalHound.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CUsingWinHeadlessDoc

IMPLEMENT_DYNCREATE(CUsingWinHeadlessDoc, CDocument)

BEGIN_MESSAGE_MAP(CUsingWinHeadlessDoc, CDocument)
	ON_COMMAND(ID_SIGNALHOUND_START, &CUsingWinHeadlessDoc::OnSignalhoundStart)
END_MESSAGE_MAP()

// CUsingWinHeadlessDoc construction/destruction

CUsingWinHeadlessDoc::CUsingWinHeadlessDoc()
{
	// TODO: add one-time construction code here

}

CUsingWinHeadlessDoc::~CUsingWinHeadlessDoc()
{
}

BOOL CUsingWinHeadlessDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	reinterpret_cast<CEditView*>(m_viewList.GetHead())->SetWindowText(NULL);

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}




// CUsingWinHeadlessDoc serialization

void CUsingWinHeadlessDoc::Serialize(CArchive& ar)
{
	// CEditView contains an edit control which handles all serialization
	reinterpret_cast<CEditView*>(m_viewList.GetHead())->SerializeRaw(ar);
}


// CUsingWinHeadlessDoc diagnostics

#ifdef _DEBUG
void CUsingWinHeadlessDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CUsingWinHeadlessDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CUsingWinHeadlessDoc commands
// Please note: The application MUST have access to the calibration files for accurate readings

void CUsingWinHeadlessDoc::OnSignalhoundStart()
{
	CMySignalHound myHound;
	MEAS_RCVR_STRUCT myMeasRcvr;

	CString str, textOut ;
	textOut = "Creating myHound Object\r\n";
	int HoundNotOK = myHound.Initialize();

	if(HoundNotOK)
	{
		if(HoundNotOK == ERROR_HOUND_MISSING)
			str = "Error: No Signal Hound Connected\r\n";
		else if(HoundNotOK == ERROR_HOUND_PORTS)
			str = "Error: Signal Hound Ports will not open\r\n";
		else if(HoundNotOK == ERROR_HOUND_TEMPCOFILE)
			str = "Error: Tempco file D<serial number>.bin not in application's directory\r\n";
		else if(HoundNotOK == ERROR_HOUND_CALFILE)
			str = "Error: Cal file <serial number>.tep not in application's directory\r\n";
		else 
			str = "Unknown error\r\n";

		textOut +=str;
		reinterpret_cast<CEditView*>(m_viewList.GetHead())->SetWindowText(textOut);

		return;
	}

	str = "Initialize was successful\r\n";
	textOut += str;


	str.Format("Reading Serial number: %.8d\r\n",myHound.m_serialNumber);
	textOut += str;

	reinterpret_cast<CEditView*>(m_viewList.GetHead())->SetWindowText(textOut);
	// ************* 915 MHz narrow sweep *************
	MessageBox(NULL,"Set generator to 915 MHz, between 0 and -40 dBm","USER ACTION REQUIRED",MB_OK);

	myHound.SetCenterAndSpan(915.0e6,5.0e4); //Prepare for a sweep centered at 915 MHz

	str.Format("Reading Temperature: %.2f deg C\r\n",myHound.ReadTemperature());
	textOut += str;

	myHound.SetupForSweep();
	myHound.DoSweep();

	str.Format("m_traceSize: %d\r\n",myHound.m_traceSize);
	textOut += str;

	str.Format("m_HzPerPt: %f\r\n",myHound.m_HzPerPt);
	textOut += str;

	str.Format("myHound.m_settings.m_centerFreq: %f\r\n",myHound.m_settings.m_centerFreq);
	textOut += str;

	myHound.m_settings.m_RBWSetpoint = myHound.m_settings.GetBWIDX(100.0);

	int i,peakidx=0;
	for(i=1; i<myHound.m_traceSize; i++)
		if(myHound.pDataMax[i] > myHound.pDataMax[peakidx]) peakidx=i;

	double myPeak = myHound.pDataMax[peakidx];
	str.Format("peak: %.2f dBm at %.0f Hz, idx = %d\r\n",mW2dBm(myPeak),myHound.GetFrequencyFromIdx(peakidx),peakidx);
	textOut += str;


	reinterpret_cast<CEditView*>(m_viewList.GetHead())->SetWindowText(textOut);
	// ************* 97.1 MHz zero span sweep *************
	MessageBox(NULL,"Set generator to 97.1 MHz, between 0 and -40 dBm, AM or FM modulated","USER ACTION REQUIRED",MB_OK);

	myHound.SetCenterAndSpan(97.1e6,2.0e5); //Prep to RX radio station
	myHound.SetupForSweep();
	myHound.DoSweep();
	myHound.m_settings.m_decimation = 1;

	myHound.m_channelBW = 10.0e3; //Hz
	myHound.m_channelSpacing = 10.0e3; //Hz
	double channelPower = myHound.GetCP();
	double lowerACP = myHound.GetACPL() - channelPower;
	double higherACP = myHound.GetACPR() - channelPower;


	str.Format("Channel power: %.2f dBm ACP (LOW) dBc : %.2f ACP (High): %.2f dBc\r\n",channelPower,lowerACP,higherACP);
	textOut += str;

	myMeasRcvr.AudioLPFreq = 3.0e3;	//3 KHz Cutoff
	myMeasRcvr.UseLPF = true;		
	myMeasRcvr.UseBPF = false;	
	myHound.m_settings.m_decimation = HOUND_IFBW_60kHz;
	
	myHound.DoMeasuringReceiver(&myMeasRcvr);
	
	str.Format("Peak +: %.1f Hz, peak-: %.1f Hz, AMRMS %.2f pct, Counter: %.2f Hz\r\n",
		myMeasRcvr.FMPeakPlus, myMeasRcvr.FMPeakMinus, myMeasRcvr.AMRMS, myMeasRcvr.RFCounter);
	textOut += str;

	//Zero span settings
	myHound.m_settings.m_sweepMode = 3; //Zero span = 3
	myHound.m_settings.m_ZSMode = HOUND_ZS_MODE_AMPLITUDE;
	myHound.m_settings.m_RBWSetpoint = HOUND_IFBW_120kHz;
	myHound.m_settings.m_VBWSetpoint = HOUND_IFBW_120kHz;
	myHound.m_settings.m_ZSSweepTime = 0.001; //seconds.
	myHound.m_settings.m_startFreq = myHound.m_settings.m_centerFreq;
	myHound.m_settings.m_stopFreq = myHound.m_settings.m_centerFreq;
	myHound.m_settings.m_spanFreq = 0.0;

	myHound.ReadTemperature();

	myHound.SetupForSweep();
	myHound.DoSweep();

	str.Format("Zero Span m_traceSize: %d\r\n",myHound.m_traceSize);
	textOut += str;

	str.Format("m_HzPerPt: %f\r\n",myHound.m_HzPerPt);
	textOut += str;

	str.Format("myHound.m_settings.m_centerFreq: %f\r\n",myHound.m_settings.m_centerFreq);
	textOut += str;

	peakidx=0;
	for(i=1; i<myHound.m_traceSize; i++)
		if(myHound.pDataMax[i] > myHound.pDataMax[peakidx]) peakidx=i;

	str.Format("peak: %.2f dBm at %.0f Hz, idx = %d\r\n",mW2dBm(myHound.pDataMax[peakidx]),myHound.GetFrequencyFromIdx(peakidx),peakidx);
	textOut += str;

	reinterpret_cast<CEditView*>(m_viewList.GetHead())->SetWindowText(textOut);

}
