#include "pcr_api.h"

#include <iostream>

// This example illustrates how to open a device Sets the
// GPS dynamic platform model to mobile .When finished, the program 
// closes the device indicating that it is no longer going to be used, 
// and can be opened by another program.

void pcr_example_write_key_pair_gps()
{
    PCRStatus sts;
    int handle;

    // Connect the device
    sts = pcrConnectDevice(&handle, PCR_DEFAULT_HOST_ADDR, PCR_DEFAULT_DEVICE_ADDR, PCR_DEFAULT_PORT);
    if (sts != PCRStatusNoError) {
        printf("Error opening device: %s\n", pcrGetErrorString(sts));
        return;
    }
    
    uint32_t key = 0x20110021;  // Dynamic platform model
    uint64_t value = 0;         // 
    int valueLen = 1;           // 1 byte field
    pcrWriteMessageToGPS(handle, key, value, valueLen);

    key = 0x10340014;   // Use BeiDou geostationary satellites (PRN 1-5and 59 - 63)
    value = 0;          // false
    valueLen = 1;       // 1 byte field
    pcrWriteMessageToGPS(handle, key, value, valueLen); 

    key = 0x20110011;   // Position fix mode
    value = 1;          // 2d Fix only
    valueLen = 1;       // 1 byte field
    pcrWriteMessageToGPS(handle, key, value, valueLen);

    // Wait until timebase is gps disiplined and print of GPS data to demonstrate that the GPS functions as desired. Altitude should be grabage using a 2d fix only
    pcrSetGPSTimebaseUpdate(handle, PCRBool::PCRBoolTrue);
    PCRGPSState state = PCRGPSStateNotPresent;
    do {
        pcrGetGPSState(handle, &state);
    } while (state != PCRGPSStateDisciplined);


    PCRBool updated;
    int64_t secSinceEpoch;
    double latitude;
    double longitude;
    double altitude;
    pcrGetGPSInfo(handle, PCRBoolTrue, &updated, &secSinceEpoch, &latitude, &longitude, &altitude);

    printf("GPS Info\nupdated: %d\nsecSinceEpoch : %lld\nlat : %lf\nlon : %lf\nalt : %lf\n", updated, secSinceEpoch, latitude, longitude, altitude);

    pcrCloseDevice(handle);
}