#include "pcr_api.h"

#include <iostream>
#include <cassert>
#include <Windows.h>

#pragma comment(lib, "pcr_api.lib")

// This example illustrates how to setup a single PCR to stream VITA49 to
// a destination network address.

// The destination network address
const uint64_t mac = 0x3CFDFE9ECF10;
const char *hostIP = "192.168.2.2";
const uint16_t port = 4992;

// Streaming configuration
const int streamingChannels = 4;
const int decimation = 2; // [1,2,4]
const double refLevel = -20.0;
const double centerFreq = 900.0e6;

int main()
{
    PCRStatus sts = PCRStatusNoError;
    int handle = -1;
    sts = pcrConnectDevice(&handle, PCR_DEFAULT_HOST_ADDR, PCR_DEFAULT_DEVICE_ADDR, PCR_DEFAULT_PORT);
    assert(sts == PCRStatusNoError);

    // Setup the VRT stream
    sts = pcrSetStreamMode(handle, PCRStreamModeVRT);
    assert(sts == PCRStatusNoError);
    for(int i = 0; i < streamingChannels; i++) {
        sts = pcrSetStreamVrtChannelID(handle, i, i);
        assert(sts == PCRStatusNoError);
        sts = pcrSetStreamVrtAddr(handle, i, hostIP, port, mac);
        assert(sts == PCRStatusNoError);
    }
    sts = pcrSetStreamVrtCntxInterval(handle, PCRBoolTrue, 63);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamVrtEndianness(handle, PCREndiannessBig);
    assert(sts == PCRStatusNoError);

    // Now setup the channels + measurement
    int chEnabled[4] = { 1, 1, 1, 1 };
    sts = pcrSetChannelConfig(handle, chEnabled, PCR_SWEEP_CHANNEL_DISABLED);
    assert(sts == PCRStatusNoError);
    for (int j = 0; j < streamingChannels; j++) {
        sts = pcrSetChannelShared(handle, j, PCRBoolTrue);
        assert(sts == PCRStatusNoError);
    }
    sts = pcrSetSharedFreq(handle, centerFreq);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamDataType(handle, PCRDataType16sc);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamRefLevel(handle, refLevel);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamAtten(handle, PCR_AUTO_ATTEN);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamSampleRate(handle, decimation);
    assert(sts == PCRStatusNoError);
    sts = pcrSetStreamBandwidth(handle, PCR_STREAM_MAX_BW);
    assert(sts == PCRStatusNoError);
    sts = pcrInitiate(handle);
    assert(sts == PCRStatusNoError);

    std::cout << "Streaming\n";
}