% This function illustrates using the streaming I/Q class to acquire a
% single I/Q capture and then plots it.
pid = matlabProcessID;
pcr = PCRIQStreamer();
fprintf('Open Status: %s\n', pcr.getstatusstring());
fprintf('SN = %d\n', pcr.SerialNumber);

pcr.SharedCenterFrequency = 1.0e9;
pcr.ChannelsEnabled(1,1:end) = [1 1 1 1];
pcr.IsChannelShared(1,1:end) = [false true true true];
pcr.IndepCenterFrequency(1,1) = 2.0e9;
pcr.DecimationFactor = 2;
pcr.Bandwidth = pcr.samplerate() * 0.8;
pcr.RefLevel = 0.0;
pcr.OutputFormat = 'non-interleaved';
pcr.NumDevices = 1;

pcr.pair();

% Start the receiver, collect IQ data, and stop the receiver
pcr.start();
iq = pcr.recv(1e6, true);
pcr.stop();

% iterate through the devices and channels and plot the data for the active channels, AM vs time.
numActiveChans = 0;
clf("reset");
for dev = 1:pcr.NumDevices
    for chan = 1:4
        if pcr.ChannelsEnabled(dev,chan) > 0
            %must track active channels as the data that is output is only
            %from the active channels
            numActiveChans = numActiveChans + 1;
            plotIndex = (dev - 1) * 4 + chan;
            subplot(pcr.NumDevices,4,plotIndex);
            plot(10*log10(abs(iq(:,numActiveChans)).^2));
            formattedTitle = sprintf('Device %d Chan %d\n', dev,chan);
            title(formattedTitle);
        end
    end
end
