#include <iostream>
#include <vector>
#include <algorithm>

#include "sa_api.h"

int main(int argc, char **argv)
{
    int handle = -1;
    saOpenDevice(&handle);
    std::cout << "Device handle " << handle << "\n";

    int serial = 0;
    saGetSerialNumber(handle, &serial);
    std::cout << "Device serial " << serial << "\n";

    float temp = 0.0;
    saQueryTemperature(handle, &temp);
    std::cout << "Dev Temp = " << temp << "C \n";

    float voltage = 0.0;
    saQueryDiagnostics(handle, &voltage);
    std::cout << "Dev Voltage = " << voltage << "V \n";

    double startFreq = 0.5e9, stopFreq = 1.5e9;
    double rbw = 50.0e3;

    saConfigAcquisition(handle, SA_MIN_MAX, SA_LOG_SCALE);
    saConfigCenterSpan(handle, (startFreq + stopFreq) / 2.0, stopFreq - startFreq);
    saConfigLevel(handle, -30.0);
    saConfigGainAtten(handle, SA_AUTO_ATTEN, SA_AUTO_GAIN, false);
    saConfigSweepCoupling(handle, rbw, rbw, true/*false*/);

    saInitiate(handle, SA_SWEEPING, 0);
    int len = 0;
    double start = 0, bin = 0;
    saQuerySweepInfo(handle, &len, &start, &bin);

    std::cout << "Sweep Len " << len << std::endl;
    std::cout << "Start Freq " << start << std::endl;
    std::cout << "Bin Size " << bin << std::endl;

    std::vector<float> min, max;
    min.resize(len);
    max.resize(len);

    std::cout << "Sweeping Full Span... Please wait" << std::endl;
    saGetSweep_32f(handle, &min[0], &max[0]);
    auto it = std::max_element(max.begin(), max.end());
    std::cout << "Peak Amplitude = " << *it<< "\n";
    std::cout << "Peak Amplitude at " << ((it - max.begin()) * bin + start) /1.0e6 << " MHz\n";
    std::cout << max[it - max.begin()] << std::endl;

    saAbort(handle);

    saCloseDevice(handle);

    return -1;
}
