# Signal Hound PCR4200 API - Python Language Bindings

For support please contact support@signalhound.com.

## Prerequisites

Python 3 is required to use the Python interface functions. The API has been
tested with Python 3.13.5 on Windows.

The Spike software must be fully installed before using the Python
interface functions. Additionally, ensure the PCR receiver is stable and
functioning in Spike before using the Python interface.

Several NumPy and SciPy packages are required to use the Python interface
functions, due to the need for fast array processing. The easiest way is to
install the SciPy stack, available here: https://www.scipy.org/install.html.
Alternatively, the necessary individual packages could be installed.

## Purpose

This project enables the user to retrieve sampled IQ data and frequency
sweeps from the PCR receiver through a number of convenience functions
written in Python. These functions serve as a binding to our PCR API,
and perform the majority of C shared library interfacing necessary to communicate
with the receiver.

## Setup

### Windows

Place the pcr_api.py and pcr_api.dll files into the pcrdevice/ folder.

To call the functions from outside the pcrdevice/ directory you may need to add the
pcrdevice folder to the Python search path and to the system path. This can be done
by editing PATH and PYTHONPATH in:

> Control Panel > System and Security > System > Advanced system settings > Advanced > Environment Variables > System variables.

### Linux

Place the pcr_api.py and libpcr_api.so files into the pcrdevice/ folder. If necessary remove version information from libpcr_api.so.

Edit the line in pcr_api.py from

    smlib = CDLL("pcrdevice/pcr_api.dll")
        to
    smlib = CDLL("pcrdevice/libpcr_api.so").

---

To run the example scripts, navigate to the folder containing the example
.py files. Each example file is standalone and provides example code for calling the
provided Python functions for the PCR4200.

## Usage

The functions under the "Functions" heading are callable from external scripts.
They are functionally equivalent to their C counterparts.

For the acquisition functions, user-allocated NumPy arrays are passed in and filled by the API.
