#include "pcr_api.h"

#include <iostream>

// This example illustrates how to open a PCR device and print some basic 
//   diagnostic data. Opening the device is the first step in using the PCR. 
// When finished, the program closes the device, telling the API to reclaim
//   any resources associated with the device, allowing it to be opened again.

void pcr_example_connect_device()
{
    PCRStatus sts;
    int handle;
 
    // Connect the device
    sts = pcrConnectDevice(&handle, PCR_DEFAULT_HOST_ADDR, PCR_DEFAULT_DEVICE_ADDR, PCR_DEFAULT_PORT);
    if(sts != PCRStatusNoError) {
        printf("Error opening device: %s\n", pcrGetErrorString(sts));
        return;
    }

    // Retrieve some diagnostics
    int serialNumber;
    int major, minor, rev;
    float voltage, current, temp;

    pcrGetSerialNumber(handle, &serialNumber);
    pcrGetFirmwareVersion(handle, &major, &minor, &rev);
    pcrGetDeviceDiagnostics(handle, &voltage, &current, &temp);

    // Print diagnostics
    printf("Serial number: %d\n", serialNumber);
    printf("Firmware version: %d.%d.%d\n", major, minor, rev);
    printf("Device temp: %.2f C\n", temp);

    pcrCloseDevice(handle);
}