#pragma once

#define _WINSOCK_DEPRECATED_NO_WARNINGS
#include <cstdint>
#include <winsock2.h>
// stops windows.h including winsock.
#define _WINSOCKAPI_
#include <Windows.h>

#include "sh_vrt.h"

#include <vector>

// Stores the current xfer size parameters that the DataTransfer classes use.
namespace NetXferSizes {
    // This is the maximum number of data grams that will ever be requested by one
    // recv()/WSARecv() function call.
    const int DGRAMS_PER_XFER = 256;
    // Maximum size of any data gram returned. Is large enough to account for any
    // UDP packet returned from PCR.
    const int DGRAM_DATA_LEN = 9000;
    // The maximum number of asynchronous recv()/WSARecv() requests that can be
    // active at any time. The maximum amount of data requested is
    // DGRAMS_PER_XFER * DGRAM_DATA_LEN * XFER_SLOTS
    const int XFER_SLOTS = 32;
}

struct CmdXferStatus {
    bool Success() const { return !Failed(); }
    bool Failed() const { return timeout || (xferLen != xferLenRequested); }

    bool timeout;
    int xferLen;
    int xferLenRequested;
};

struct XferStatus {
    // true if timeout
    bool timeout = false;
    int dgramsRequested;
    // Pointer to the xfer buffer
    uint8_t* p[NetXferSizes::DGRAMS_PER_XFER];
    // Actual bytes xferred (bytes)
    int xferLen[NetXferSizes::DGRAMS_PER_XFER];

    bool Success() const { return !Failed(); }
    bool Failed() const { return timeout; }
};

class NetworkedDataTransfer {
public:
    NetworkedDataTransfer(SOCKET socket, int slot);
    ~NetworkedDataTransfer();

    void BeginDataXfer(int dataGrams, int timeoutMs);
    const XferStatus* FinishDataXfer();

private:
    int slot;

    // Does not own
    SOCKET socket;

    // UDP buffers
    static const int WSA_BUFS = 1;
    WSABUF wsaBufs[NetXferSizes::DGRAMS_PER_XFER];

    // Overlapped IO structs
    WSAOVERLAPPED overlapped[NetXferSizes::DGRAMS_PER_XFER];
    HANDLE eventArray[NetXferSizes::DGRAMS_PER_XFER];

    // Datagram buffers
    uint8_t* inputBuf[NetXferSizes::DGRAMS_PER_XFER];

    // cached variables between begin/finish
    int dgramsInFlight;
    int timeoutRequested;

    bool timedOut;

    XferStatus xferStatus;
};

struct PktInfo {
    VRTPacketType type;
    int id;
};

class V49Ingestor {
public:
    V49Ingestor() {}

    void ParsePkts(const XferStatus *sts);

    uint64_t lastClear = -1;
    std::vector<PktInfo> history;

    int lastPktCounter = -1;
};