# This example demonstrates
# 1. Using PyVISA (https://pyvisa.readthedocs.io/) to connect to the VSG60 software
# 2. Configuring the software for an ARB output
# 3. Waiting for the *OPC bit to be set in the status register

import pyvisa
from time import sleep

def wait_for_opc(inst):
    inst.write("*OPC")
    while True:
        esr = int(inst.query("*ESR?"))
        if esr:
            break
        sleep(16e-3)

def scpi_vsg_arb_simple():
    # Get the VISA resource manager
    rm = pyvisa.ResourceManager()

    # Open a session to the VSG software, VSG software must be running at this point
    inst = rm.open_resource('TCPIP::localhost::5024::SOCKET')

    # For SOCKET programming, we want to tell VISA to use a terminating character
    #   to end a read and write operation.
    inst.read_termination = '\n'
    inst.write_termination = '\n'

    inst.write("OUTPUT ON")
    inst.write("OUTPUT:MOD OFF")
    inst.write("FREQ 1GHz")
    inst.write("POW -30")

    # Configure modulation
    print(inst.write("RADIO:ARB:STATE ON"))
    print(inst.write("RADIO:ARB:TRIGGER:TYPE CONT"))
    print(inst.write("RADIO:ARB:SRATE 16.384MHz"))
    print(inst.write("RADIO:ARB:IQ:SCALE:AUTO OFF"))
    print(inst.write("RADIO:ARB:IQ:SCALE:AVER OFF"))

    #Update file path with the location of your data file
    filePath = "C:\\YourFolderPath\\"
    fileName = "AM-16_384000MHz-1_000000000GHz_FC.csv"
    fullFileName = filePath + fileName
    fullFileName = "\"" + fullFileName + "\"" #Add Quotes around file name
    readFileInstruction = "RADIO:ARB:WAVEFORM:LOAD:CSV " + fullFileName
    print(inst.write(readFileInstruction))

    # Enable modulation
    inst.write("OUTPUT:MOD ON")

    wait_for_opc(inst)

    # Done
    inst.close()

if __name__ == "__main__":
    scpi_vsg_arb_simple()
