# This example illustrates how to open a PCR device and print some basic
#   diagnostic data. Opening the device is the first step in using the PCR.
# When finished, the program closes the device, telling the API to reclaim
#   any resources associated with the device, allowing it to be opened again.

from pcrdevice.pcr_api import *

def pcr_example_connect_device():
    # Connect the device
    status, handle = pcr_connect_device(PCR_DEFAULT_HOST_ADDR, PCR_DEFAULT_DEVICE_ADDR, PCR_DEFAULT_PORT).values()
    if status != PCRStatus.PCRStatusNoError:
        print(f'Error opening device: {pcr_get_error_string(status)}')
        return

    # Retrieve some diagnostics
    status, serial_number = pcr_get_serial_number(handle).values()
    status, major, minor, rev = pcr_get_firmware_version(handle).values()
    status, voltage, current, temp = pcr_get_device_diagnostics(handle).values()

    # Print diagnostics
    print(f'Serial number: {serial_number}')
    print(f'Firmware version: {major}.{minor}.{rev}')
    print(f'Device temp: {temp:.2f} C')

    pcr_close_device(handle)

if __name__ == '__main__':
    pcr_example_connect_device()
