import numpy as np
from .timestamp import Timestamp

class IFFrame:
    """
    Represents a frame of IF (Intermediate Frequency) time-domain sample data
    """
    timestamp: Timestamp
    """Time of first sample in the frame"""
    sample_delta: float
    """Sample period"""
    center_frequency: float
    """RF center frequency of the data in the frame (offset from DC)"""
    gain_dB: float
    """Gain to apply to the samples"""
    bandwidth: float
    """Buffer of samples"""
    data: np.ndarray

    def __init__(self):
        self.timestamp = Timestamp()
        self.sample_delta = 1.0
        self.center_frequency = 0.0
        self.gain_dB = 0.0
        self.bandwidth = 0.0
        self.data = np.zeros(0, dtype=np.float32)


class SpectralFrame:
    """
    Represents a single frame of spectral data
    """
    timestamp: Timestamp
    """Time of the center of the time window used to produce this spectral frame"""
    frame_delta: float
    """Nominal time between each spectral frame"""
    frequency_start: float
    """Frequency (Hz) of first spectral bin in the frame"""
    frequency_delta: float
    """Delta (Hz) between each spectral bin"""
    data: np.ndarray
    """Buffer of frequency bins"""

    def __init__(self):
        self.timestamp = Timestamp()
        self.frame_delta = 1.0
        self.frequency_start = 0.0
        self.frequency_delta = 1.0
        self.data = np.zeros(0, dtype=np.float32)
