import setuptools

# Source the README.md description
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

# Source the module version
version = {}
with open("src/sceptrelivestream/version.py", "r") as fh:
    exec(fh.read(), version)

if __name__ == '__main__':
    setuptools.setup(
        name="sceptrelivestream",
        version=version['__version__'],
        author="Jason Blackaby",
        description="Python 3 module for reading Sceptre VITA-49 LiveStreams",
        long_description=long_description,
        long_description_content_type="text/markdown",
        classifiers=[
            "Programming Language :: Python :: 3",
            "Operating System :: OS Independent",
        ],
        packages=['sceptrelivestream'],
        package_dir={'': 'src'},
        python_requires=">=3.6",
        setup_requires=[
            'wheel'
        ],
        install_requires=[
            'numpy',
            'matplotlib'
        ]
    )
